@extends('layouts.master')
@section('title')
	{{isset($activity) ? 'Edit activity': 'Add activity'}}
@endsection
@section('css')
<!---Internal Fileupload css-->
<link href="{{URL::asset('assets/plugins/fileuploads/css/fileupload.css')}}" rel="stylesheet" type="text/css"/>
@endsection
@section('page-header')
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">activity</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ {{isset($activity) ? 'Edit': 'Create'}}</span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
@endsection
@section('content')
	<!-- row -->
	<div class="row row-sm">

		<!-- activity form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="{{isset($activity) ? Route('activities.update', ['activity'=>$activity->id]) : Route('activities.store')}}" enctype="multipart/form-data">
						@csrf
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="type_id">Activity Type</label>
							<select name="type_id" id="type_id" class="form-control" required>
								<option value="" disabled selected>Choose Type</option>
								<?php $type_id = isset($activity) ? $activity->type_id : ''; ?>
								@foreach ($types as $type)
									<option value="{{$type->id}}" {{$type_id == $type->id ? 'selected': ''}}>{{$type->name}}</option>
								@endforeach
							</select>
							@if ($errors->has('type_id'))
								<p class="help text-danger">{{$errors->first('type_id')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="category_id">Category</label>
							<select name="category_id" id="category_id" class="form-control" required>
								<option value="" disabled selected>Choose Category</option>
								<?php $category_id = isset($activity) ? $activity->category_id : ''; ?>
								@foreach ($categories as $category)
									<option value="{{$category->id}}" {{$category_id == $category->id ? 'selected': ''}}>{{$category->name}}</option>
								@endforeach
							</select>
							@if ($errors->has('category_id'))
								<p class="help text-danger">{{$errors->first('category_id')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="{{isset($activity) ? $activity->title : old('title')}}" placeholder="Enter title">
							@if ($errors->has('title'))
								<p class="help text-danger">{{$errors->first('title')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview</label>
							<input type="text" class="form-control" name="overview" id="overview" required value="{{isset($activity) ? $activity->overview : old('overview')}}" placeholder="Enter overview">
							@if ($errors->has('overview'))
								<p class="help text-danger">{{$errors->first('overview')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								{{ isset($activity) ? $activity->description : old('description') }}
							</textarea>
							@if ($errors->has('description'))
								<p class="help text-danger">{{$errors->first('description')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="difficulty">Difficulty</label>
							<select name="difficulty" id="difficulty" class="form-control" required>
								<option value="" disabled selected>Choose Difficulty</option>
								<?php $difficulty = isset($activity) ? $activity->difficulty : ''; ?>
								<option value="Beginner" {{$difficulty == "Beginner" ? 'selected': ''}}>Beginner</option>
								<option value="Intermediate" {{$difficulty == "Intermediate" ? 'selected': ''}}>Intermediate</option>
								<option value="Advanced" {{$difficulty == "Advanced" ? 'selected': ''}}>Advanced</option>
							</select>
							@if ($errors->has('difficulty'))
								<p class="help text-danger">{{$errors->first('difficulty')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="duration">duration (in seconds)</label>
							<input type="number" class="form-control" name="duration" id="duration" min="30" max="7200" required value="{{isset($activity) ? $activity->duration : old('duration')}}" placeholder="Enter duration">
							@if ($errors->has('duration'))
								<p class="help text-danger">{{$errors->first('duration')}}</p>
							@endif
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												@if (isset($activity))
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="{{config('app.uploads')}}{{$activity->main_image}}"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="{{$activity->title}}"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												@endif
											</div>
										</div>
										@if ($errors->has('main_image'))
											<p class="help text-danger">{{$errors->first('main_image')}}</p>
										@endif
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->



						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">{{isset($activity) ? 'Update': 'Create'}}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- activity form END -->
		
		@isset($activity)
		<!-- assign exercise form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
			    
			    <div class="card-title ml-3">
			        Assign Exercise To ({{$activity->title}})
		        </div>
		        
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="{{Route('assign_activity_exercise')}}" enctype="multipart/form-data">
						@csrf
						
						<input type="hidden" name="activity_id" value="{{$activity->id}}">
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="exercise_id">Exercise</label>
							<select name="exercise_id" id="exercise_id" class="form-control" required>
								<option value="" disabled selected>Choose exercise</option>
								@foreach ($exercises as $exercise)
									<option value="{{$exercise->id}}">{{$exercise->title}}</option>
								@endforeach
							</select>
							@if ($errors->has('exercise_id'))
								<p class="help text-danger">{{$errors->first('exercise_id')}}</p>
							@endif
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="reps">reps</label>
							<input type="number" class="form-control" name="reps" id="reps" required value="{{isset($activity) ? $activity->reps : old('reps')}}" placeholder="Enter reps">
							@if ($errors->has('reps'))
								<p class="help text-danger">{{$errors->first('reps')}}</p>
							@endif
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="sets">sets</label>
							<input type="number" class="form-control" name="sets" id="sets" required value="{{isset($activity) ? $activity->sets : old('sets')}}" placeholder="Enter sets">
							@if ($errors->has('sets'))
								<p class="help text-danger">{{$errors->first('sets')}}</p>
							@endif
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="rest_between_sets">rest between sets</label>
							<input type="number" class="form-control" name="rest_between_sets" id="rest_between_sets" required value="{{isset($activity) ? $activity->rest_between_sets : old('rest_between_sets')}}" placeholder="Enter rest between sets">
							@if ($errors->has('rest_between_sets'))
								<p class="help text-danger">{{$errors->first('rest_between_sets')}}</p>
							@endif
						</div>
						
						<div class="form-group col-12">
							<label class="text-capitalize" for="rest_between_exercises">rest between exercises</label>
						    <input type="number" class="form-control" name="rest_between_exercises" id="rest_between_exercises" required value="{{isset($activity) ? $activity->rest_between_exercises : old('rest_between_exercises')}}" placeholder="Enter rest between exercises">
							@if ($errors->has('rest_between_exercises'))
								<p class="help text-danger">{{$errors->first('rest_between_exercises')}}</p>
							@endif
						</div>


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">Assign</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- assign exercise form END -->
		
		
		<!-- assignd exercises START -->
		<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Asseined Exercises</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all border-bottom-0">#</th>
										<th class="all border-bottom-0">exercise</th>
										<th class="all border-bottom-0">reps</th>
										<th class="all border-bottom-0">sets</th>
										<th class="all border-bottom-0">rest between sets</th>
										<th class="all border-bottom-0">rest between exercises</th>
										<th class="all border-bottom-0">date</th>
										<th class="all border-bottom-0">Action</th>
									</tr>
								</thead>
								<tbody>
								    <?php $i=1; ?>
									@foreach ($assigned_exercises as $assigned_exercise)
									<tr>
										<td>{{$i}}</td>
										<td>{{$assigned_exercise->exercise? $assigned_exercise->exercise->title: ''}}</td>
										<td>{{$assigned_exercise->reps}}</td>
										<td>{{$assigned_exercise->sets}}</td>
										<td>{{$assigned_exercise->rest_between_sets}}</td>
										<td>{{$assigned_exercise->rest_between_exercises}}</td>
										<td>{{date('d M Y', strtotime($assigned_exercise->created_at))}}</td>
										<td>
											<a href="{{ route('delete_assigned_exercise', ['id' => $assigned_exercise->id]) }}" class="deleteRow mx-1" data-id="{{$assigned_exercise->id}}"><i class="fa-solid fa-trash text-danger"></i></a>
										</td>
									</tr>
									<?php $i++; ?>
									@endforeach
								</tbody>
							</table>
						</div>
						<!-- End Table -->


					</div>
				</div>
			</div>
		<!-- assignd exercises END -->
		@endisset


	</div>
	<!-- row -->


</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
@endsection
@section('js')
<!--Internal Fileuploads js-->
<script src="{{URL::asset('assets/plugins/fileuploads/js/fileupload.js')}}"></script>
<script src="{{URL::asset('assets/plugins/fileuploads/js/file-upload.js')}}"></script>
<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>

@endsection