<?php
	if(auth()->check()) {
		header('Location: '.route('login'));
    	exit();
	}
	
?>

@extends('layouts.master2')
@section('css')
<!-- Sidemenu-respoansive-tabs css -->
<link href="{{URL::asset('assets/plugins/sidemenu-responsive-tabs/css/sidemenu-responsive-tabs.css')}}" rel="stylesheet">
@endsection
@section('content')
		<div class="container-fluid">
			<div class="row no-gutter">
				<!-- The image half -->
				<div class="col-md-6 col-lg-6 col-xl-7 d-none d-md-flex bg-primary-transparent">
					<div class="row wd-100p mx-auto text-center">
						<div class="col-md-12 col-lg-12 col-xl-12 my-auto mx-auto wd-100p">
							<img src="{{URL::asset('assets/img/media/login.jpg')}}" class="my-auto ht-xl-80p wd-md-100p wd-xl-80p mx-auto" alt="logo">
						</div>
					</div>
				</div>
				<!-- The content half -->
				<div class="col-md-6 col-lg-6 col-xl-5 bg-white">
					<div class="login d-flex align-items-center py-2">
						<!-- Demo content-->
						<div class="container p-0">
							<div class="row">
								<div class="col-md-10 col-lg-10 col-xl-9 mx-auto">
									<div class="card-sigin">
										<div class="mb-5 d-flex"> <a href="{{ url('/' . $page='index') }}"><img src="{{URL::asset('assets/img/brand/favicon.png')}}" class="sign-favicon ht-40" alt="logo"></a><h1 class="main-logo1 mr-0 my-auto tx-28">Dashboard</h1></div>
										<div class="card-sigin">
											<div class="main-signup-header">
												<h2>Welcome back!</h2>
												<h5 class="font-weight-semibold mb-4">Please sign in to continue.</h5>
												<form method="POST" action="{{ route('login') }}">
													@csrf
													<div class="form-group">
														<label>Email</label>
														<input type="email" name="email" class="form-control @error('email') is-invalid @enderror" value="{{ old('email') }}" required autofocus placeholder="Enter your email">
														@error('email')
															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror
													</div>
													<div class="form-group position-relative">
														<label>Password</label>
														<input id="password" type="password" class="form-control password-input @error('password') is-invalid @enderror" name="password" required  placeholder="Enter your password">
														<span class="toggle-password" data-toggle="off">
															<i class="fa fa-eye toggle-eye-icon"></i>
														</span>
														
													</div>
													<button class="btn btn-main-primary btn-block mb-3">Sign In</button>
												</form>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div><!-- End -->
					</div>
				</div><!-- End -->
			</div>
		</div>
@endsection
@section('js')
<script>
	$(document).ready(function() {

		$('.toggle-password').on('click', function() {
			if( $('.toggle-eye-icon').hasClass('fa-eye') )  {
				$('.password-input').attr('type', 'text');
				$('.toggle-eye-icon').removeClass('fa-eye').addClass('fa-eye-slash');
			} else {
				$('.password-input').attr('type', 'password');
				$('.toggle-eye-icon').removeClass('fa-eye-slash').addClass('fa-eye');
			}
		});

	});
	
</script>
@endsection