@extends('layouts.master')
@section('title')
	{{isset($exercise) ? 'Edit exercise': 'Add exercise'}}
@endsection
@section('css')
<!---Internal Fileupload css-->
<link href="{{URL::asset('assets/plugins/fileuploads/css/fileupload.css')}}" rel="stylesheet" type="text/css"/>
@endsection
@section('page-header')
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">exercise</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ {{isset($exercise) ? 'Edit': 'Create'}}</span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
@endsection
@section('content')
	<!-- row -->
	<div class="row row-sm">

		<!-- exercise form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="{{isset($exercise) ? Route('exercises.update', ['exercise'=>$exercise->id]) : Route('exercises.store')}}" enctype="multipart/form-data">
						@csrf


						<div class="form-group col-12">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="{{isset($exercise) ? $exercise->title : old('title')}}" placeholder="Enter title">
							@if ($errors->has('title'))
								<p class="help text-danger">{{$errors->first('title')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="overview">overview (optional)</label>
							<input type="text" class="form-control" name="overview" id="overview" value="{{isset($exercise) ? $exercise->overview : old('overview')}}" placeholder="Enter overview">
							@if ($errors->has('overview'))
								<p class="help text-danger">{{$errors->first('overview')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description (optional)</label>
							<textarea name="description" id="editor" rows="10" class="form-control">
								{{ isset($exercise) ? $exercise->description : old('description') }}
							</textarea>
							@if ($errors->has('description'))
								<p class="help text-danger">{{$errors->first('description')}}</p>
							@endif
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="difficulty">Difficulty</label>
							<select name="difficulty" id="difficulty" class="form-control" required>
								<option value="" disabled selected>Choose Difficulty</option>
								<?php $difficulty = isset($exercise) ? $exercise->difficulty : ''; ?>
								<option value="Beginner" {{$difficulty == "Beginner" ? 'selected': ''}}>Beginner</option>
								<option value="Intermediate" {{$difficulty == "Intermediate" ? 'selected': ''}}>Intermediate</option>
								<option value="Advanced" {{$difficulty == "Advanced" ? 'selected': ''}}>Advanced</option>
							</select>
							@if ($errors->has('difficulty'))
								<p class="help text-danger">{{$errors->first('difficulty')}}</p>
							@endif
						</div>

						<!--<div class="form-group col-12">-->
						<!--	<label class="text-capitalize" for="duration">duration (in seconds)  (optional)</label>-->
						<!--	<input type="number" class="form-control" name="duration" id="duration" min="1" max="7200" value="{{isset($exercise) ? $exercise->duration : old('duration')}}" placeholder="Enter duration">-->
						<!--	@if ($errors->has('duration'))-->
						<!--		<p class="help text-danger">{{$errors->first('duration')}}</p>-->
						<!--	@endif-->
						<!--</div>-->
						
						<!--<div class="form-group col-12">-->
						<!--	<label class="text-capitalize" for="sets">sets (optional)</label>-->
						<!--	<input type="number" class="form-control" name="sets" id="sets" min="1" max="1000" value="{{isset($exercise) ? $exercise->sets : old('sets')}}" placeholder="Enter sets">-->
						<!--	@if ($errors->has('sets'))-->
						<!--		<p class="help text-danger">{{$errors->first('sets')}}</p>-->
						<!--	@endif-->
						<!--</div>-->

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" accept="image/*" class="dropify" data-height="200" />
												</div>
												@if (isset($exercise))
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="{{config('app.uploads')}}{{$exercise->main_image}}"
														class="shadow-1-strong rounded mb-4 img-fluid"
														alt="{{$exercise->title}}"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												@endif
											</div>
										</div>
										@if ($errors->has('main_image'))
											<p class="help text-danger">{{$errors->first('main_image')}}</p>
										@endif
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->



						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">{{isset($exercise) ? 'Update': 'Create'}}</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- exercise form END -->

	</div>
	<!-- row -->

	<!-- Video Upload -->
	@isset($exercise)
	<!-- row -->
	<div class="row row-sm">
		<!-- Video form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="{{route("upload/video/exercise")}}" enctype="multipart/form-data">
						@csrf
						<input type="hidden" name="record_id" value="{{$exercise->id}}">
						<input type="hidden" name="title" value="{{$exercise->title}}">
						<input type="hidden" name="description" value="{{$exercise->overview}}">
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video" accept="video/*" class="dropify" data-height="200" />
												</div>
												@if (isset($exercise->player_embed_url))
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<iframe src="{{$exercise->player_embed_url}}" width="640" height="360" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" title="{{$exercise->title}}"></iframe>
												</div>
												@endif
											</div>
										</div>
										@if ($errors->has('video'))
											<p class="help text-danger">{{$errors->first('video')}}</p>
										@endif
									</div>
								</div>
							</div>
						</div>
						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary">Upload Video</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- Video form END -->
	</div>
	<!-- row -->
	@endisset
	<!-- Video Upload -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
@endsection
@section('js')
<!--Internal Fileuploads js-->
<script src="{{URL::asset('assets/plugins/fileuploads/js/fileupload.js')}}"></script>
<script src="{{URL::asset('assets/plugins/fileuploads/js/file-upload.js')}}"></script>
<!-- Include the CKEditor library -->
<script src="https://cdn.ckeditor.com/ckeditor5/36.0.1/classic/ckeditor.js"></script>

<!-- Initialize CKEditor -->
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>

@endsection