@extends('layouts.master')
@section('title', 'Customers')

@section('page-header')
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Dashboard</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ Customers</span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
@endsection
@section('content')

		<div class="loader-container hidden">
			<div class="spinner-bcustomer"></div>
		</div>

		<!-- row opened -->
		<div class="row row-sm">

			<div class="col-xl-12">
				<div class="card">
					<div class="card-header pb-0">
						<div class="d-flex justify-content-between">
							<h4 class="card-title mg-b-0">Customers TABLE</h4>
							<i class="mdi mdi-dots-horizontal text-gray"></i>
						</div>
					</div>
					<div class="card-body">

						<!-- Start Filter -->
						<div class="filter-box mb-5">
							<form action="{{route('customers.index', ['page'=>1])}}" method="GET">

								<input type="hidden" name="page" value="1">
								<input type="hidden" name="filter" value="1">
					
								<div class="row bg-white pt-4">
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="number" class="form-control" name="phone" placeholder="Phone">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="text" class="form-control" name="fullname" placeholder="Name">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<input type="text" class="form-control date" name="created_at" placeholder="Registiration Date">
										</div>
									</div>
									<div class="col-6 col-lg-3">
										<div class="form-group">
											<button type="submit" class="btn btn-danger" style="width: 100%"><i class="fa-solid fa-magnifying-glass"></i> Filter</button>
										</div>
									</div>
								</div>
						
							</form>
						</div>
						<!-- End Filter -->

						<!-- Start Table -->
						<div class="table-responsive">
							<table class="table text-md-nowrap" id="example1">
								<thead>
									<tr>
										<th class="all">Id</th>
										<th class="all">Name</th>
										<th class="all">Email</th>
										<th class="all">Status</th>
										<th class="all">Registration date</th>
										<th class="all">Action</th>
									</tr>
								</thead>
								<tbody>
									@foreach ($customers as $customer)
									<tr>
										<input type="hidden" class="deleted_id" value="{{$customer->id_customer}}">
										<td>{{$customer->id_customer}}</td>
										<td>{{$customer->fullname}}</td>
										<td>{{$customer->email}}</td>
										@if ($customer->active == 1)
										<td>Active <i class="fa-solid fa-lightbulb ml-2 text-success"></i></td>
										@elseif($customer->active == 2)
										<td>Blocked <i class="fa fa-lightbulb ml-2 text-danger"></i></td>
										@else
										<td>Inactive <i class="fa fa-lightbulb ml-2 text-danger"></i></td>
										@endif
										<td>{{date("d M Y", strtotime($customer->date_add))}}</td>
										<td>
											<a href="customers/{{$customer->id_customer}}"><i class="fa-solid fa-pen-to-square"></i></a>
										</td>
									</tr>
									@endforeach
								</tbody>
							</table>
						</div>
						<!-- End Table -->



						<!-- Start Pagination -->
						@if (count($customers) > 0)
		
						<div class="text-center text-md-left font-size-14 mb-3 text-lh-1">Page {{$page}}–{{$num_of_pages}}</div>
						<nav aria-label="Page navigation" id="pagiantionNav">
							<ul class="list-pagination-1 pagination bcustomer bcustomer-color-4 rounded-sm mb-5 mb-lg-0 overflow-auto overflow-xl-visible justify-content-md-center align-items-center py-2">
								
								<li class="page-item {{$page==1 ? 'disabled' : ''}}">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="1" aria-label="Previous" title="Start">
										<i class="fa-solid fa-angles-left"></i>
									</a>
								</li>
								<li class="page-item {{$page==1 ? 'disabled' : ''}}">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="{{$page-1}}" aria-label="Previous">
										<i class="fa-solid fa-angle-left" title="Previous"></i>
									</a>
								</li>
		
								<?php
									if($page < 11) {
										$pagination_start = 1;
									} else {
										$pagination_start = ((int) ($page / 10)) * 10;
									}
								?>
		
								@for ($page_count = $pagination_start, $i=1; $page_count <= $num_of_pages; $page_count++, $i++)
		
								<?php if ($i>10) { break;} ?>
		
								<li class="page-item {{$page==$page_count ? 'active disabled-link' : ''}}">
									<a class="page-link font-size-14 text-dark {{$page==$page_count ? 'text-white' : ''}}" href="#" data-page="{{$page_count}}">{{$page_count}}</a>
								</li>
								
								@endfor
		
								<li class="page-item {{$page==$num_of_pages ? 'disabled' : ''}}">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="{{$page+1}}" aria-label="Next">
										<i class="fa-solid fa-angle-right" title="Next"></i>
									</a>
								</li>
								<li class="page-item {{$page==$num_of_pages ? 'disabled' : ''}}">
									<a class="page-link bg-none  rounded-0 text-dark" href="#" data-page="{{$num_of_pages}}" aria-label="Next" title="End">
										<i class="fa-solid fa-angles-right"></i>
									</a>
								</li>
								
							</ul>
						</nav>
		
						@endif
						<!-- End Pagination -->


					</div>
				</div>
			</div>
			<!--/div-->
		</div>
		<!-- /row -->
	</div>
	<!-- Container closed -->
</div>
<!-- main-content closed -->
@endsection
@section('js')

<script>

	function pagination($this) {
		var page = $this.data('page');

		var params = new URLSearchParams(location.search);
		params.set('page', page);
		window.location.search = params.toString();

	}
	

	$(document).ready(function() {

		// *** Pagination
		$('#pagiantionNav .page-link').on('click', function(e) {
			e.preventDefault();
			pagination($(this));
		});

		$("input.date").focus(function() {
			$(this).attr("type", "date");
		});
		
	});



</script>
@endsection