
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($review) ? 'Edit review': 'Add review'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">review</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($review) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- review form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($review) ? Route('reviews.update', ['review'=>$review->id]) : Route('reviews.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-6">
							<input type="radio" name="media_type" id="image" value="image" data-target="#image-container" required <?php echo e(isset($review) && $review->media_type == 'image' ? 'selected' : ''); ?>>
							<label class="text-capitalize" for="image">Image</label>

							<input type="radio" class="ml-2" name="media_type" id="video" value="video" data-target="#video-container" required <?php echo e(isset($review) && $review->media_type == 'video' ? 'selected' : ''); ?>>
							<label class="text-capitalize" for="video">Video</label>

							<?php if($errors->has('media_type')): ?>
								<p class="help text-danger"><?php echo e($errors->first('media_type')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<?php if($errors->has('image')): ?>
								<p class="help text-danger"><?php echo e($errors->first('image')); ?></p>
							<?php endif; ?>
							<?php if($errors->has('video')): ?>
								<p class="help text-danger"><?php echo e($errors->first('video')); ?></p>
							<?php endif; ?>
						</div>

						<!-- img Upload -->
						<div class="col-12 d-none media-container" id="image-container">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">img Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="image" class="dropify" data-height="200" />
												</div>
												<?php if(isset($review)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(config('app.uploads')); ?><?php echo e($review->media_src); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($review->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->

						<!-- video Upload -->
						<div class="col-12 media-container d-none" id="video-container">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Video Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="video" accept="video/*" class="dropify" data-height="200" />
												</div>
												<?php if(isset($review)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<video src="<?php echo e(config('app.uploads')); ?><?php echo e($review->media_src); ?>" height="300"></video>
												</div>
												<?php endif; ?>
											</div>
										</div>

									</div>
								</div>
							</div>
						</div>
						<!-- video Upload closed -->


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($review) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- review form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<script>
	$(document).ready(function() {
		$('input[name="media_type"]').change(function() {
			$(".media-container").addClass("d-none");
			$($(this).data('target')).removeClass("d-none");
		});
	});
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cosmeticbox/public_html/lavie-admin/resources/views/reviews/form.blade.php ENDPATH**/ ?>