
<?php $__env->startSection('title'); ?>
Customer Details
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm mt-3">

		<!-- customer start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
						  <tr>
							<th class="text-white py-3" scope="col">#Details</th>
							<th class="text-white py-3" scope="col">#<?php echo e($customer->id_customer); ?></th>
						  </tr>
						</thead>
						<tbody>
						  <tr>
							<th scope="row">fullname</th>
							<td><?php echo e($customer->fullname); ?></td>
						  </tr>
						  <tr>
							<th scope="row">phone</th>
							<td><?php echo e($customer->phoneNumber); ?></td>
						  </tr>
						  <tr>
							<th scope="row">email</th>
							<td><?php echo e($customer->email); ?></td>
						  </tr>
						  <tr>
							<th scope="row">status</th>
							<td>
								<select class="form-control" name="active" id="active" data-customer-id="<?php echo e($customer->id_customer); ?>">
									<option value="1" <?php echo e($customer->active == 1 ? 'selected' : ''); ?> >Active</option>
									<option value="0" <?php echo e($customer->active == 0 ? 'selected' : ''); ?> >Inactive</option>
								</select>
							</td>
						  </tr>
						  <tr>
							<th scope="row">date</th>
							<td><?php echo e(date('d M Y', strtotime($customer->date_add))); ?></td>
						  </tr>
						  
						</tbody>
					</table>
	
				</div>
			</div>
		</div>
		<!-- customer END -->

		<!-- Health data start -->
		<?php if(isset($customer->health_info)): ?>
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body">

					<table class="table">
						<thead class="bg-primary py-3">
							<tr>
								<th class="text-white py-3" scope="col" style="width: 30%;">#Customer Health Info</th>
								<th class="text-white py-3" scope="col">#<?php echo e($customer->health_info->id); ?></th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<th scope="row" style="width: 30%;">gender</th>
								<td><?php echo e($customer->health_info->gender); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">birth date</th>
								<td><?php echo e($customer->health_info->birth_date); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">weight</th>
								<td><?php echo e($customer->health_info->weight); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">height</th>
								<td><?php echo e($customer->health_info->height); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">fat level</th>
								<td>
									<?php switch($customer->health_info->fat_level):
										case (1): ?>
											UNDERWEIGHT
											<?php break; ?>
										<?php case (2): ?>
											NORMAL
											<?php break; ?>
										<?php case (3): ?>
											OVERWEIGHT
											<?php break; ?>
										<?php case (4): ?>
											OBESE
											<?php break; ?>
										<?php case (5): ?>
											EXTREMELY_OBESE
											<?php break; ?>
										<?php default: ?>
											Undefined
									<?php endswitch; ?>
								</td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">fitness level</th>
								<td><?php echo e($customer->health_info->fitness_level); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">is diseased ?</th>
								<td><?php echo e($customer->health_info->is_diseased); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">disease type</th>
								<td><?php echo e($customer->health_info->disease_type); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">is smoke ?</th>
								<td><?php echo e($customer->health_info->is_smoke); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">goal</th>
								<td><?php echo e($customer->health_info->goal); ?></td>
							</tr>
							<tr>
								<th scope="row" style="width: 30%;">account type</th>
								<td><?php echo e($customer->health_info->account_type); ?></td>
							</tr>
						</tbody>
					</table>
					
	
				</div>
			</div>
		</div>	
		<?php endif; ?>
		
		<!-- Health data END -->


	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>

	function updateCustomerStatus(data) {

		var ajaxPromise = ajaxRequest('POST', "<?php echo e(url('admin/updatecustomerstatus')); ?>", data);

		ajaxPromise.done(function(response) {
			swalAlert(response.message, '' ,response.status);
		});

		ajaxPromise.fail(function(xhr, status, error) {
			swalAlert('Request failed', '' ,0);
			console.log('Request failed:', error);
		});

	}

	$('document').ready(function() {
		$('select[name="active"]').on("change", function() {
			
			let data = {
				"customer_id" : $(this).data('customer-id'),
				"active" : $(this).val(),
			};

			updateCustomerStatus(data);
		});
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smartcredit/public_html/fitnasyum-ad/resources/views/customers/form.blade.php ENDPATH**/ ?>