
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($product) ? 'Edit product': 'Add product'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">product</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($product) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- product form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($product) ? Route('products.update', ['product'=>$product->id]) : Route('products.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-6">
							<label class="text-capitalize" for="title">title</label>
							<input type="text" class="form-control" name="title" id="title" required value="<?php echo e(isset($product) ? $product->title : old('title')); ?>" placeholder="Enter title">
							<?php if($errors->has('title')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="title_ar">arabic title</label>
							<input type="text" class="form-control" name="title_ar" id="title_ar" required value="<?php echo e(isset($product) ? $product->title_ar : old('title_ar')); ?>" placeholder="Enter arabic title">
							<?php if($errors->has('title_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('title_ar')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="slug">product slug</label>
							<?php if(!isset($product)): ?>
							<label> - (Permlink: https://masterfit.com/ar/product/new-product)</label>
							<?php endif; ?>
							<input type="text" class="form-control" name="slug" id="slug" required value="<?php echo e(isset($product) ? $product->slug : old('slug')); ?>" placeholder="Ex: new-product">
							<?php if($errors->has('slug')): ?>
								<p class="help text-danger"><?php echo e($errors->first('slug')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-6">
							<label class="text-capitalize" for="original_price">original price</label>
							<input type="number" class="form-control" name="original_price" id="original_price" required value="<?php echo e(isset($product) ? $product->original_price : old('original_price')); ?>" placeholder="Enter original price">
							<?php if($errors->has('original_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('original_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="sell_price">sell price</label>
							<input type="number" class="form-control" name="sell_price" id="sell_price" required value="<?php echo e(isset($product) ? $product->sell_price : old('sell_price')); ?>" placeholder="Enter sell price">
							<?php if($errors->has('sell_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('sell_price')); ?></p>
							<?php endif; ?>
						</div>


						<div class="form-group col-12">
							<label class="text-capitalize" for="description">description</label>
							<textarea class="description" name="description" rows="8"><?php echo e(isset($product) ? $product->description : old('description')); ?></textarea>
							<?php if($errors->has('description')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="description_ar">arabic description</label>
							<textarea class="description_ar" name="description_ar" rows="8"><?php echo e(isset($product) ? $product->description_ar : old('description_ar')); ?></textarea>
							<?php if($errors->has('description_ar')): ?>
								<p class="help text-danger"><?php echo e($errors->first('description_ar')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="category_id">category</label>
							<?php isset($product) ? $category_id = $product->category_id : $category_id = '';  ?>
							<select name="category_id" id="category_id" class="form-control" required>
								<option value="" selected disabled>Choose category</option>
								<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option value="<?php echo e($category->id); ?>" <?php echo e($category->id == $category_id ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<?php if($errors->has('category_id')): ?>
								<p class="help text-danger"><?php echo e($errors->first('category_id')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize" for="floor_price">floor price</label>
							<input type="number" class="form-control" name="floor_price" id="floor_price" required value="<?php echo e(isset($product) ? $product->floor_price : 150); ?>" placeholder="Enter floor_price">
							<?php if($errors->has('floor_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('floor_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($product) ? $featured = $product->featured : $featured = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="featured" value="1" <?php echo e($featured ? 'checked' : ''); ?> class="custom-control-input" id="featured">
									<label for="featured" class="custom-control-label mt-1"> Is featured?</label>
								</div>
							</div>
						</div>

						<!-- img Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">image Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="main_image" class="dropify" data-height="200" />
												</div>
												<?php if(isset($product)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(asset('uploads/'.$product->main_image)); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($product->title); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php if($errors->has('main_image')): ?>
											<p class="help text-danger"><?php echo e($errors->first('main_image')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- img Upload closed -->

						<!-- gallery Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">

										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">gallery Upload</h6>
											</div>
											<div class="row mb-4">
												<div class="col-sm-12 col-md-4">
													<input type="file" name="gallery[]" class="dropify" multiple="multiple" data-height="200" />
												</div>

												<!-- Gallery IMGS -->
												<?php if(isset($product->gallery)): ?>
											
												<?php $images = explode(', ', $product->gallery); ?>
							
													<?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<?php if($image == null): ?>
														<?php continue; ?>
													<?php endif; ?>
													<div class="col-sm-12 col-md-4 mb-4 mb-lg-0">
														<img
															src="<?php echo e(asset('uploads/'.$image)); ?>"
															class="w-100 shadow-1-strong rounded mb-4 img-fluid"
															alt="<?php echo e($product->title); ?> img"
															style="max-height: 210px; min-height: 210px;"
														/>
													</div>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							
												<?php endif; ?>
												<!-- Gallery IMGS END -->
												
											</div>
										</div>
										<?php if($errors->has('gallery')): ?>
											<p class="help text-danger"><?php echo e($errors->first('gallery')); ?></p>
										<?php endif; ?>

										<?php for($i = 0; $i < 15; $i++): ?>
										<?php if($errors->has('gallery.' . $i)): ?>
											<p class="help text-danger">IMG Num(<?php echo e($i); ?>) - <?php echo e($errors->first('gallery.' . $i)); ?></p>
										<?php endif; ?>
										<?php endfor; ?>

									</div>
								</div>
							</div>
						</div>
						<!-- gallery Upload closed -->


						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($product) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- product form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>
<!--tinymce js-->
<script src="https://cdn.tiny.cloud/1/z11c2h50n7nrfmryazjs4xzib8487mkjns9jlwpqns4wd715/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

<script>

	// tinymce

	tinymce.init({
        selector: '.description',
        height : '400',
		plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
      	toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
		font_size_formats: '8px 10px 12px 14px 16px 17px 18px 20px 22px 24px 28px 32px 36px 40px 48px 56px 64px',
    });

	tinymce.init({
        selector: '.description_ar',
        height : '400',
		plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
      	toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
		font_size_formats: '8px 10px 12px 14px 16px 17px 18px 20px 22px 24px 28px 32px 36px 40px 48px 56px 64px',
		content_style: "body { direction: rtl; text-align: right; }",
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\masterfit-admin\resources\views/products/form.blade.php ENDPATH**/ ?>