
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($area) ? 'Edit area': 'Add area'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">area</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($area) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">

		<!-- area form start -->
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($area) ? Route('areas.update', ['area'=>$area->id]) : Route('areas.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>

						<div class="form-group col-6">
							<label class="text-capitalize">english name</label>
							<input type="text" class="form-control" disabled value="<?php echo e($area->name_en); ?>">
						</div>

						<div class="form-group col-6">
							<label class="text-capitalize">arabic name</label>
							<input type="text" class="form-control" disabled value="<?php echo e($area->name_ar); ?>">
						</div>

						<div class="form-group col-12">
							<label class="text-capitalize" for="delivery_price">delivery price</label>
							<input type="number" class="form-control" name="delivery_price" id="delivery_price" required value="<?php echo e(isset($area) ? $area->delivery_price : old('delivery_price')); ?>" placeholder="Enter delivery_price">
							<?php if($errors->has('delivery_price')): ?>
								<p class="help text-danger"><?php echo e($errors->first('delivery_price')); ?></p>
							<?php endif; ?>
						</div>

						<div class="form-group col-12 mt-2 mb-4">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php isset($area) ? $active = $area->active : $active = 0; ?>
									<input type="checkbox" data-checkboxes="mygroup" name="active" value="1" <?php echo e($active ? 'checked' : ''); ?> class="custom-control-input" id="active">
									<label for="active" class="custom-control-label mt-1"> Is active?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($area) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
		<!-- area form END -->

	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\masterfit-admin\resources\views/areas/form.blade.php ENDPATH**/ ?>