
<?php $__env->startSection('title'); ?>
	<?php echo e(isset($hospital) ? 'Edit Hospital': 'Add Hospital'); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
<!-- Internal Select2 css -->
<link href="<?php echo e(URL::asset('assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">
<!--Internal  Datetimepicker-slider css -->
<link href="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/css/amazeui.datetimepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.css')); ?>" rel="stylesheet">
<!---Internal Fileupload css-->
<link href="<?php echo e(URL::asset('assets/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css"/>

<!-- Internal Spectrum-colorpicker css -->
<link href="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.css')); ?>" rel="stylesheet">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-header'); ?>
	<!-- breadcrumb -->
	<div class="breadcrumb-header justify-content-between">
		<div class="my-auto">
			<div class="d-flex">
				<h4 class="content-title mb-0 my-auto">Hospital</h4><span class="text-muted mt-1 tx-13 mr-2 mb-0">/ <?php echo e(isset($hospital) ? 'Edit': 'Create'); ?></span>
			</div>
		</div>
	</div>
	<!-- breadcrumb -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
	<!-- row -->
	<div class="row row-sm">
		<div class="col-sm-12">
			<div class="card pt-4 box-shadow-0">
				<div class="card-body pt-0">
					<form class="form-horizontal row" method="POST" action="<?php echo e(isset($hospital) ? Route('hospitals.update', ['hospital'=>$hospital->id]) : Route('hospitals.store')); ?>" enctype="multipart/form-data">
						<?php echo csrf_field(); ?>
						<div class="form-group col-12">
							<label class="text-capitalize" for="name">hospital name</label>
							<input type="text" class="form-control" name="name" id="name" required value="<?php echo e(isset($hospital) ? $hospital->name : old('name')); ?>" placeholder="Enter hospital name">
							<?php if($errors->has('name')): ?>
								<p class="help text-danger"><?php echo e($errors->first('name')); ?></p>
							<?php endif; ?>
						</div>

						<!--Specialities-->
						<div class="col-12 mt-4">
							<div class="table-responsive">
								<table class="table table-bordered table-addRmeove">
									<thead>
										<tr>
											<th class="text-capitalize font-size-13">Speciality</th>
											<th class="text-capitalize font-size-13">Price</th>
											<th class="text-capitalize font-size-13">Note</th>
											<th class="text-capitalize font-size-13">action</th>
										</tr>
									</thead>
									<tbody id="tbody_specialities" class="tbody">
										<?php if(isset($hospital)): ?> 
										<?php $i=0; ?>
										<?php $__currentLoopData = json_decode($hospital->specialties); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $speciality_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr id="R_<?php echo e($i); ?>" data-counter="<?php echo e($i); ?>">
											<td class="row-index" width="20%">
												<div class="form-group">
													<select class="form-control" name="specialty[<?php echo e($i); ?>]" required>
														<option label="Choose one"></option>
														<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($specialty->specialty); ?>" <?php echo e($specialty->specialty == $speciality_item->specialty ? 'selected' : ''); ?>>
															<?php echo e($specialty->specialty); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</td>
											<td class="row-index" width="20%">
												<div class="form-group">
													<input type="number" class="form-control" name="specialty_price[<?php echo e($i); ?>]" value="<?php echo e($speciality_item->price); ?>" placeholder="Enter Price" required>
												</div>
											</td>
											<td class="row-index" width="40%">
												<div class="form-group">
													<input type="text" class="form-control" name="specialty_note[<?php echo e($i); ?>]" value="<?php echo e(isset($speciality_item->note) ? $speciality_item->note : ''); ?>" placeholder="Enter Note">
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php $i++;  ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php else: ?>
										<tr id="R_0" data-counter="0">
											<td class="row-index" width="20%">
												<div class="form-group">
													<select class="form-control" name="specialty[0]" required>
														<option label="Choose one"></option>
														<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($specialty->specialty); ?>">
															<?php echo e($specialty->specialty); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</td>
											<td class="row-index" width="20%">
												<div class="form-group">
													<input type="number" class="form-control" name="specialty_price[0]" placeholder="Enter Price" required>
												</div>
											</td>
											<td class="row-index" width="40%">
												<div class="form-group">
													<input type="text" class="form-control" name="specialty_note[0]" placeholder="Enter Note">
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
						<!--End Specialities-->

						<!--Insurance-->
						<div class="col-12 mt-4">
							<div class="table-responsive">
								<table class="table table-bordered table-addRmeove">
									<thead>
										<tr>
											<th class="text-capitalize font-size-13">insurance companies</th>
											<th class="text-capitalize font-size-13">action</th>
										</tr>
									</thead>
									<tbody id="tbody_insurance" class="tbody">
										<?php if(isset($hospital)): ?> 
										<?php $i=0;  ?>
										<?php $__currentLoopData = json_decode($hospital->insurance); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insurance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr id="R2_<?php echo e($i); ?>" data-counter="<?php echo e($i); ?>">
											<td class="row-index" width="80%">
												<div class="form-group">
													<input type="text" class="form-control" name="insurance[<?php echo e($i); ?>]" value="<?php echo e($insurance->company); ?>" placeholder="Enter Company Name" required>
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php $i++;  ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										
										<?php else: ?>
										<tr id="R2_0" data-counter="0">
											<td class="row-index" width="80%">
												<div class="form-group">
													<input type="text" class="form-control" name="insurance[0]" placeholder="Enter Company Name" required>
												</div>
											</td>
											<td width="20%">
												<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
												<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
											</td>
										</tr>
										<?php endif; ?>
									</tbody>
								</table>
							</div>
						</div>
						<!--End Insurance-->
						
						<div class="form-group col-6">
							<label class="text-capitalize" for="cost">cost</label>
							<input type="number" class="form-control" name="cost" id="cost" required value="<?php echo e(isset($hospital) ? $hospital->cost : old('cost')); ?>" placeholder="Enter cost">
							<?php if($errors->has('cost')): ?>
								<p class="help text-danger"><?php echo e($errors->first('cost')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="rate">rate</label>
							<input type="number" step="0.1" class="form-control" name="rate" id="rate" required value="<?php echo e(isset($hospital) ? $hospital->rate : old('rate')); ?>" placeholder="Enter rate">
							<?php if($errors->has('rate')): ?>
								<p class="help text-danger"><?php echo e($errors->first('rate')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="phone">phone</label>
							<input type="number" class="form-control" name="phone" id="phone" required value="<?php echo e(isset($hospital) ? $hospital->phone : old('phone')); ?>" placeholder="Enter phone">
							<?php if($errors->has('phone')): ?>
								<p class="help text-danger"><?php echo e($errors->first('phone')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="governorate">governorate</label>
							<input type="text" class="form-control" name="governorate" id="governorate" required value="<?php echo e(isset($hospital) ? $hospital->governorate : old('governorate')); ?>" placeholder="Enter governorate">
							<?php if($errors->has('governorate')): ?>
								<p class="help text-danger"><?php echo e($errors->first('governorate')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="city">city</label>
							<input type="text" class="form-control" name="city" id="city" required value="<?php echo e(isset($hospital) ? $hospital->city : old('city')); ?>" placeholder="Enter city name">
							<?php if($errors->has('city')): ?>
								<p class="help text-danger"><?php echo e($errors->first('city')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="address">address</label>
							<input type="text" class="form-control" name="address" id="address" required value="<?php echo e(isset($hospital) ? $hospital->address : old('address')); ?>" placeholder="Enter hospital address">
							<?php if($errors->has('address')): ?>
								<p class="help text-danger"><?php echo e($errors->first('address')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lng">longitude</label>
							<input type="text" class="form-control" name="lng" id="lng" required value="<?php echo e(isset($hospital) ? json_decode($hospital->location)->lng : old('lng')); ?>" placeholder="Enter Location longitude">
							<?php if($errors->has('lng')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lng')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-6">
							<label class="text-capitalize" for="lat">latitude</label>
							<input type="text" class="form-control" name="lat" id="lat" required value="<?php echo e(isset($hospital) ? json_decode($hospital->location)->lat : old('lat')); ?>" placeholder="Enter Location latitude">
							<?php if($errors->has('lat')): ?>
								<p class="help text-danger"><?php echo e($errors->first('lat')); ?></p>
							<?php endif; ?>
						</div>
						<div class="form-group col-12">
							<label class="text-capitalize" for="brief">brief</label>
							<textarea class="form-control" rows="3" name="brief" id="brief" placeholder="Enter hospital Brief"><?php echo e(isset($hospital) ? $hospital->brief : old('brief')); ?></textarea>
							<?php if($errors->has('brief')): ?>
								<p class="help text-danger"><?php echo e($errors->first('brief')); ?></p>
							<?php endif; ?>
						</div>

						<!--Days Off-->
						<div class="col-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Days Off
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<div class="row row-sm mg-b-20">
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<div class="form-group d-inline-block">
											<div class="checkbox">
												<div class="custom-checkbox custom-control">
													<?php if(isset($hospital)): ?>
													<?php $daysOff = json_decode($hospital->daysOff); ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1" class="custom-control-input" <?php echo e(in_array($i, $daysOff) ? 'checked' : ''); ?> id="daysOff_<?php echo e($i); ?>">
													<?php else: ?>
													<input type="checkbox" data-checkboxes="mygroup" name="daysOff[<?php echo e($i); ?>]" value="1" class="custom-control-input" id="daysOff_<?php echo e($i); ?>">
													<?php endif; ?>
													<label for="daysOff_<?php echo e($i); ?>" class="custom-control-label mt-1"> <?php echo e($day); ?></label>
												</div>
											</div>
										</div>
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>									

									
								</div>
							</div>
						</div>
						<!--Days Off Closed-->

						<!--available_hours-->
						<div class="col-md-12 col-xl-12 col-xs-12 col-sm-12">
							<div class="card">
								<div class="card-body">
									<div class="main-content-label mg-b-20">
										Available hours
									</div>
									<?php
										$days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
										$i=0;
									?>
									<?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if(isset($hospital)): ?>
									<?php $available_hours =  json_decode($hospital->available_hours);?>
									<?php endif; ?>
									<div class="row row-sm mg-b-20">
										<div class="input-group wd-125 mr-3">
											<div class="input-group-prepend">
												<div class="input-group-text wd-125">
													<?php echo e($day); ?>

												</div>
											</div>
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													From
												</div>
											</div><input class="form-control" name="from[<?php echo e($i); ?>]" value="<?php echo e(isset($hospital) ?  $available_hours[$i]->from : ''); ?>" type="time" required>
										</div>
										<div class="input-group col-6 col-md-4">
											<div class="input-group-prepend">
												<div class="input-group-text">
													To
												</div>
											</div><input class="form-control" name="to[<?php echo e($i); ?>]" value="<?php echo e(isset($hospital) ?  $available_hours[$i]->to : ''); ?>" type="time" required>
										</div>
									</div>									
									<?php $i++;?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									
								</div>
							</div>
						</div>
						<!--available_hours Closed-->

						<!-- Image Upload -->
						<div class="col-12">
							<div class="row">
								<div class="col-md-12">
									<div class="card">
										<div class="card-body">
											<div>
												<h6 class="card-title mb-1">Image Upload</h6>
											</div>
											<div class="row mb-4">
												<?php if(isset($hospital)): ?>
												<div class="col-lg-4 col-md-12 mb-4 mb-lg-0">
													<img
														src="<?php echo e(asset('/uploads/hospitals/'.$hospital->pic)); ?>"
														class="w-100 shadow-1-strong rounded mb-4 img-fluid"
														alt="<?php echo e($hospital->name); ?>"
														style="max-height: 210px; min-height: 210px;"
													/>
												</div>
												<?php endif; ?>
												<div class="col-sm-12 col-md-4">
													<input type="file" name="pic" class="dropify" data-height="200" />
												</div>
											</div>
										</div>
										<?php if($errors->has('pic')): ?>
											<p class="help text-danger"><?php echo e($errors->first('pic')); ?></p>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!-- Image Upload closed -->

						<div class="form-group col-12">
							<div class="checkbox">
								<div class="custom-checkbox custom-control">
									<?php if(isset($hospital)): ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" <?php echo e($hospital->premium == 'true' ? 'checked' : ''); ?> class="custom-control-input" id="premium">
									<?php else: ?>
									<input type="checkbox" data-checkboxes="mygroup" name="premium" value="true" class="custom-control-input" id="premium">
									<?php endif; ?>
									<label for="premium" class="custom-control-label mt-1"> Premium ?</label>
								</div>
							</div>
						</div>

						<div class="form-group col-12 mb-0 mt-3 justify-content-end">
							<div>
								<button type="submit" class="btn btn-primary"><?php echo e(isset($hospital) ? 'Update': 'Create'); ?></button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
	<!-- row -->

</div>
<!-- Container closed -->
</div>
<!-- main-content closed -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<!--Internal  Datepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>
<!--Internal Fileuploads js-->
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/fileupload.js')); ?>"></script>
<script src="<?php echo e(URL::asset('assets/plugins/fileuploads/js/file-upload.js')); ?>"></script>

<!--Internal dynamicrows js-->
<script src="<?php echo e(URL::asset('assets/js/dynamicrows.js')); ?>"></script>

<!--Internal  jquery.maskedinput js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery.maskedinput/jquery.maskedinput.js')); ?>"></script>
<!--Internal  spectrum-colorpicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/spectrum-colorpicker/spectrum.js')); ?>"></script>
<!-- Internal Select2.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/select2/js/select2.min.js')); ?>"></script>
<!--Internal Ion.rangeSlider.min js -->
<script src="<?php echo e(URL::asset('assets/plugins/ion-rangeslider/js/ion.rangeSlider.min.js')); ?>"></script>
<!--Internal  jquery-simple-datetimepicker js -->
<script src="<?php echo e(URL::asset('assets/plugins/amazeui-datetimepicker/js/amazeui.datetimepicker.min.js')); ?>"></script>
<!-- Ionicons js -->
<script src="<?php echo e(URL::asset('assets/plugins/jquery-simple-datetimepicker/jquery.simple-dtpicker.js')); ?>"></script>
<!--Internal  pickerjs js -->
<script src="<?php echo e(URL::asset('assets/plugins/pickerjs/picker.min.js')); ?>"></script>
<!-- Internal form-elements js -->
<script src="<?php echo e(URL::asset('assets/js/form-elements.js')); ?>"></script>

<script>
    $(document).ready(function () {

		// ******** Start specialties ********

		// Denotes total number of rows
		var rowIdx;
		// jQuery button click event to add a row
		$('#tbody_specialities').on('click', '.addBtn', function () {

			rowIdx = $(this).parents('tbody').find("tr").last().data('counter');

			// Adding a row inside the tbody.
			$('#tbody_specialities').append(`
			<tr id="R_${++rowIdx}" data-counter="${rowIdx}">
				<td class="row-index" width="20%">
					<div class="form-group">
						<select class="form-control" name="specialty[${rowIdx}]" required>
							<option label="Choose one"></option>
							<?php $__currentLoopData = $specialities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $specialty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($specialty->specialty); ?>">
								<?php echo e($specialty->specialty); ?>

							</option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
				</td>
				<td class="row-index" width="20%">
					<div class="form-group">
						<input type="number" class="form-control" name="specialty_price[${rowIdx}]" placeholder="Enter Price" required>
					</div>
				</td>
				<td class="row-index" width="40%">
					<div class="form-group">
						<input type="text" class="form-control" name="specialty_note[${rowIdx}]" placeholder="Enter Note">
					</div>
				</td>
				<td width="20%">
					<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
					<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
				</td>
			</tr>`);
		});

      	// jQuery button click event to remove a row.
		$('#tbody_specialities').on('click', '.remove', function () {

			// Check If Is There Only One Row
			if($(this).parents('tbody').find("tr").length == 1) {

			} else {

				// Getting all the rows next to the row
				// containing the clicked button
				var child = $(this).closest('tr').nextAll();

				// Iterating across all the rows 
				// obtained to change the index
				child.each(function () {

					// Getting <tr> id.
					var id = $(this).attr('id');

					// Getting the <p> inside the .row-index class.
					var idx = $(this).children('.row-index').children('p');

					// Gets the row number from <tr> id.
					var dig = parseInt(id.substring(1));

					// Modifying row index.
					idx.html(`Row ${dig - 1}`);

					// Modifying row id.
					$(this).attr('id', `R_${dig - 1}`);
				});

				// Removing the current row.
				$(this).closest('tr').remove();

				// Decreasing total number of rows by 1.
				rowIdx--;

			}
		});

		

		// ******** End specialties ********

		// *********************************

		// ******** Start Insurance ********

		// Denotes total number of rows
		var rowIdx2;
		// jQuery button click event to add a row
		$('#tbody_insurance').on('click', '.addBtn', function () {

		rowIdx2 = $(this).parents('tbody').find("tr").last().data('counter');

		// Adding a row inside the tbody.
		$('#tbody_insurance').append(`<tr id="R2_${++rowIdx2}" data-counter="${rowIdx2}">
			<td class="row-index" width="70%">
				<div class="form-group">
					<input type="text" class="form-control" name="insurance[${rowIdx2}]" placeholder="Enter Company Name" required>
				</div>
			</td>
			<td width="30%">
				<button class="btn remove" type="button"><i class="fa-solid fa-minus text-danger"></i></button>
				<button class="btn addBtn" type="button"><i class="fa-solid fa-plus text-primary"></i></button>
				</td>
			</tr>`);
		});

      	// jQuery button click event to remove a row.
		$('#tbody_insurance').on('click', '.remove', function () {

			// Check If Is There Only One Row
			if($(this).parents('tbody').find("tr").length == 1) {

			} else {

				// Getting all the rows next to the row
				// containing the clicked button
				var child = $(this).closest('tr').nextAll();

				// Iterating across all the rows 
				// obtained to change the index
				child.each(function () {

					// Getting <tr> id.
					var id = $(this).attr('id');

					// Getting the <p> inside the .row-index class.
					var idx = $(this).children('.row-index').children('p');

					// Gets the row number from <tr> id.
					var dig = parseInt(id.substring(1));

					// Modifying row index.
					idx.html(`Row ${dig - 1}`);

					// Modifying row id.
					$(this).attr('id', `R2_${dig - 1}`);
				});

				// Removing the current row.
				$(this).closest('tr').remove();

				// Decreasing total number of rows by 1.
				rowIdx2--;

			}
		});


		// ******** End Insurance ********
    });
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\moalj_admin\resources\views/hospitals/form.blade.php ENDPATH**/ ?>